function [DD, D]=aggregateAvg(x,n)

%[DD, D] = AGGREGATE(x,n)
%       aggregate by taking averages over a window of length n, the vector x
%       sliding of one element at time. 
% ------------------------------------------------------------------------
% Output:
%       DD = a vector of non overlapping aggregate avg of length x/n
%       D  = an overlapping aggregate vector of n elements 
%       having the same length of the original x (default value for n is 5).
%
%       See also aggregate and aggregateKeepingTimeStamp
% -------------------------------------------------------------------------
% Fulvio Corsi 2003

N=length(x);
if nargin < 2, n=5; end

aggr=ones(n,1);
D=filter(aggr,1,x)./n; %n aggregation
% D(1:n-1)=D(n);  % for the price? to be checked...
for i=1:n-1,
    D(i)=D(i)*n/i;
end
DD=D(find(mod(find(D | D==0),n)==0)); %decimation 
